﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.ComponentModel;

namespace iXTankenSimple
{
    public abstract class ViewModelBase : INotifyPropertyChanged
    {

        public void Initialize()
        {
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected virtual void RaisePropertyChanged(string propertyName) 
        { 
            PropertyChangedEventHandler handler = this.PropertyChanged; 
            if (handler != null) 
            { 
                handler(this, new PropertyChangedEventArgs(propertyName)); 
            } 
        }

        protected T GetService<T>() where T : class 
        { 
            if (typeof(T) == typeof(INavigationService)) 
            { 
                return new iXTankenNavigationService() as T; 
            } 
            else if (typeof(T) == typeof(ITankvorgangModelService)) 
            { 
                return new InMemoryTankVorgangModelService() as T; 
            } 
            return null; 
        }
    }
}
